;******************************************************************************
;                                                                             *
;    Other Files Required: p30F2010.gld, p30f2010.inc                         *
;    Tools Used:	MPLAB IDE                                             *
;                                                                             *
;    Notes:				                                      *
;   This is a program to produce simple video output from a dsPIC chip        *
;   Written by Jon Prestidge.   www.properbostin.co.uk                        *
;                                                                             *
;    I used the dsPICDEM 28-pin Starter Demo Board                            * 
;                                                                             *
;******************************************************************************

        .equ __30F2010, 1
        .include "p30f2010.inc"

;..............................................................................
;Configuration bits:
;..............................................................................

        config __FOSC, CSW_FSCM_OFF & XT_PLL16   ;Turn off clock switching and
                                            	;fail-safe clock monitoring and
                                            	;use a crystal oscillator with
                                            	;the 4x PLL

        config __FWDT, WDT_OFF              ;Turn off Watchdog Timer

        config __FBORPOR, PBOR_ON & BORV_27 & PWRT_16 & MCLR_EN
                                            ;Set Brown-out Reset voltage and
                                            ;and set Power-up Timer to 16msecs
                                            
        config __FGS, CODE_PROT_OFF         ;Set Code Protection Off for the 
                                            ;General Segment


;..............................................................................
;Global Declarations:
;..............................................................................

        .global __reset          ;The label for the first line of code. 

        ;.global __T1Interrupt    ;Declare Timer 1 ISR name global


;..............................................................................
;Unitialized storage in data space
;..............................................................................

		.section .bss
		
Count:	.space 2

;..............................................................................
;Constants stored in Program space
;..............................................................................

        .section .asciitext, "x"
        .palign 2                ;Align next word stored in Program space to an
                                 ;address that is a multiple of 2
Message:
        .ascii	"dsPICDEM 28-pin Starter Demo Board\r\n\0"


;..............................................................................
;Code Section in Program Memory
;..............................................................................

.text                             ;Start of Code section
__reset:
        MOV #__SP_init, W15       ;Initalize the Stack Pointer
        MOV #__SPLIM_init, W0     ;Initialize the Stack Pointer Limit Register
        MOV W0, SPLIM
        NOP                       ;Add NOP to follow SPLIM initialization
        
        CALL _wreg_init           ;Call _wreg_init subroutine
                                  

		clr Count				; Initialize the count variable used in ISR

InitPorts:
                
        mov	#0x003F,W0			; Setup all analog pins for digital mode
        mov	W0,ADPCFG			; by writing ADPCFG register
        
        clr	LATB				; Clear all I/O port registers.
        clr	LATC
        clr	LATD
        clr LATE
        clr TRISB				; Make all ports outputs except RF2, RF3
        clr	TRISC				; which will be used for UART
        clr	TRISD
        clr	TRISE
        ;mov	0x000C,W0
        ;mov	W0,TRISF
        
        		
		
		bset	CORCON,#PSV		; Enable program space visibility
		
		; Load PSV page register and setup W1 as a pointer to the
		; ASCII text string stored in program memory
		mov		#psvpage(Message),W0
		mov		W0,PSVPAG		
		;mov		#psvoffset(Message),W1

		; The next block of code writes the ascii string stored in
		; program memory to to the UART.  The loop repeats until a 
		; null character is found.
      	
        ; For Interrupts...
      	;mov		#14084,W0		; Gives 1/19th second period with 7.38 MHz
      	;mov		W0,PR1			; clock and 1:8 prescaler
      	;bset	T1CON,#TCKPS0	; 1:8 timer prescaler
      	;bset	T1CON,#TON		; Turn on the timer
      	;bclr	IFS0,#T1IF
      	;bset	IEC0,#T1IE
		
        ; For no interrupts:-	
      	clr		T1CON   ; Stops the Timer1 and reset control reg.
      	clr		TMR1  ; Clear contents of the timer register
        ;MOV #0xFFFF, w0 ; Load the Period register
        ;MOV w0, PR1 ; with the value 0xFFFF
      	bclr	T1CON,#TON		; Turn OFF the timer











        bset	LATD, #0
        bclr	LATD, #1

;..............................................................................
;Software main loop
;..............................................................................





        bclr	LATD, #0
        bclr	LATD, #1

Even_Field:

        call Broard  ;line 1
        call Broard

        call Broard ; line 2
        call Broard

        call Broard ; line 3
        call Narrow

        call Narrow ; line 4
        call Narrow

        call Narrow ; line 5
        call Narrow

        call Blank_Line  ; line 6
        call Blank_Line  ; line 7
        call Blank_Line  ; line 8
        call Blank_Line  ; line 9
        call Blank_Line  ; line 10
        call Blank_Line  ; line 11
        call Blank_Line  ; line 12
        call Blank_Line  ; line 13
        call Blank_Line  ; line 14
        call Blank_Line  ; line 15
        call Blank_Line  ; line 16
        call Blank_Line  ; line 17
        call Blank_Line  ; line 18
        call Blank_Line  ; line 19
        call Blank_Line  ; line 20
        call Blank_Line  ; line 21
        call Blank_Line  ; line 22
        call Blank_Line  ; line 23-----
        call Blank_Line  ; line 24
        call Blank_Line  ; line 25
        call Blank_Line  ; line 26
        call Blank_Line  ; line 27
        call Blank_Line  ; line 28
        call Blank_Line  ; line 29

        do      #99, Lines_1_end
        call Blank_Line
        nop
Lines_1_end: nop

        call White_Line

        do      #98, Lines_2_end
        call Blank_Line
        nop
Lines_2_end: nop

        do      #81, Lines_3_end
        call Blank_Line
        nop
Lines_3_end: nop

        call Narrow ;line 311
        call Narrow 

        call Narrow ;line 312
        call Narrow 

        call Narrow ;line 313

;ODD FIELD
;---------

        call Broard ;line 313 part 2

        call Broard ;line 314
        call Broard

        call Broard ;line 315
        call Broard

        call Narrow ;line 316
        call Narrow 

        call Narrow ;line 317
        call Narrow 

        call Blank_Line  ;line 318
        call Blank_Line  ;line 319
        call Blank_Line  ;line 320
        call Blank_Line  ;line 321
        call Blank_Line  ;line 322
        call Blank_Line  ;line 323
        call Blank_Line  ;line 324
        call Blank_Line  ;line 325
        call Blank_Line  ;line 326
        call Blank_Line  ;line 327
        call Blank_Line  ;line 328
        call Blank_Line  ;line 329
        call Blank_Line  ;line 330
        call Blank_Line  ;line 331
        call Blank_Line  ;line 332
        call Blank_Line  ;line 333
        call Blank_Line  ;line 334
        call Blank_Line  ;line 335

        call Blank_Line  ;line 336
        call Blank_Line  ;line 337
        call Blank_Line  ;line 338
        call Blank_Line  ;line 339
        call Blank_Line  ;line 340
        call Blank_Line  ;line 341


        do      #99, Lines_10_end
        call Blank_Line
        nop
Lines_10_end: nop

        call White_Line

        do      #180, Lines_101_end
        call Blank_Line
        nop
Lines_101_end: nop


        call Half_Blank  ; line 623
        call Narrow

        call Narrow  ;line 624
        call Narrow

        call Narrow  ;line 625
        call Narrow

        

       bra Even_Field






; ===================================================================
;  one fully white display line
White_Line:
        CLR T1CON ; Stops the Timer1 and reset control reg.
        CLR TMR1 ; Clear contents of the timer register
        BSET T1CON, #TON ; Start Timer1

        bclr	LATD, #0
    	bclr	LATD, #1

wait_for_it:   ;4.7us SYNC TROUGH
        MOV #138, W0
        CP  TMR1
        BRA LEU, wait_for_it

        bset	LATD, #0

wait_for_it2:   ; 5.8us BACK PORCH
        MOV #310, W0
        CP  TMR1   ;29.48MHz  = 0.033921302us per cycle   e.g.: 4.7us = timer at 138.6 counts
        BRA LEU, wait_for_it2


       bset	LATD, #1
wait_for_it3:   ; THE 52us DISPLAY PERIOD OF THE LINE
        MOV #1842, W0
        CP  TMR1    ;29.48MHz  = 0.033921302us per cycle   e.g.: 4.7us = timer at 138.6 counts
        BRA LEU, wait_for_it3
       bclr	LATD, #1

wait_for_it4:   ; 1.5us FRONT PORCH
        MOV #1886, W0
        CP  TMR1     ;29.48MHz  = 0.033921302us per cycle   e.g.: 4.7us = timer at 138.6 counts
        BRA LEU, wait_for_it4

		return



;==================================================
Blank_Line:	; BLANK DISPLAY LINE
        ; 4.7us zero volts

        CLR T1CON ; Stops the Timer1 and reset control reg.
        CLR TMR1 ; Clear contents of the timer register
        BSET T1CON, #TON ; Start Timer1

        bclr	LATD, #0
    	bclr	LATD, #1

wait_for_it10:   ;4.7us SYNC TROUGH
        MOV #138, W0
        CP  TMR1
        BRA LEU, wait_for_it10

        bset	LATD, #0

wait_for_it11:   ; 5.8us BACK PORCH
        MOV #310, W0
        CP  TMR1   ;29.48MHz  = 0.033921302us per cycle   e.g.: 4.7us = timer at 138.6 counts
        BRA LEU, wait_for_it11

wait_for_it12:   ; THE 52us DISPLAY PERIOD OF THE LINE
        MOV #1842, W0
        CP  TMR1    ;29.48MHz  = 0.033921302us per cycle   e.g.: 4.7us = timer at 138.6 counts
        BRA LEU, wait_for_it12

wait_for_it13:   ; 1.5us FRONT PORCH
        MOV #1886, W0
        CP  TMR1     ;29.48MHz  = 0.033921302us per cycle   e.g.: 4.7us = timer at 138.6 counts
        BRA LEU, wait_for_it13

		return




;==================================================
Narrow:	; NARROW SYNC PULSE
        ; 2.35us zero volts,  29.65us black volts

        CLR T1CON ; Stops the Timer1 and reset control reg.
        CLR TMR1 ; Clear contents of the timer register
        BSET T1CON, #TON ; Start Timer1

        bclr	LATD, #0
    	bclr	LATD, #1

        MOV #69, W0
wait_for_it20:
        CP  TMR1
        BRA LEU, wait_for_it20

        bset	LATD, #0

        MOV #943, W0
wait_for_it21:
        CP  TMR1   ;29.48MHz  = 0.033921302us per cycle   e.g.: 4.7us = timer at 138.6 counts
        BRA LEU, wait_for_it21

		return



;=================================================================
Broard:	; BROARD SYNC PULSE
        ; 27.3us zero volts,  4.7us black volts

        CLR T1CON ; Stops the Timer1 and reset control reg.
        CLR TMR1 ; Clear contents of the timer register
        BSET T1CON, #TON ; Start Timer1

        bclr	LATD, #0
    	bclr	LATD, #1

        MOV #805, W0
wait_for_it30:
        CP  TMR1
        BRA LEU, wait_for_it30

        bset	LATD, #0

        MOV #943, W0
wait_for_it31:
        CP  TMR1   ;29.48MHz  = 0.033921302us per cycle   e.g.: 4.7us = timer at 138.6 counts
        BRA LEU, wait_for_it31

		return


;==================================================
Half_Blank:	; HALF BLANK DISPLAY LINE
        ; 4.7us zero volts
        ; 8us black volts (Back porch)
        ; 52us display

        CLR T1CON ; Stops the Timer1 and reset control reg.
        CLR TMR1 ; Clear contents of the timer register
        BSET T1CON, #TON ; Start Timer1

        bclr	LATD, #0
    	bclr	LATD, #1

        MOV #138, W0
wait_for_it40:   ;4.7us SYNC TROUGH
        CP  TMR1
        BRA LEU, wait_for_it40

        bset	LATD, #0

        MOV #943, W0
wait_for_it41:   ; the rest of the half blank line including the back porch.
        CP  TMR1
        BRA LEU, wait_for_it41

        return



; ===================================================================
;  one display line
LineA:

        CLR T1CON ; Stops the Timer1 and reset control reg.
        CLR TMR1 ; Clear contents of the timer register
        BSET T1CON, #TON ; Start Timer1

        bclr	LATD, #0
    	bclr	LATD, #1

        MOV #138, W0
wait_for_it50:   ;4.7us SYNC TROUGH
        CP  TMR1
        BRA LEU, wait_for_it50

        bset	LATD, #0

        MOV #943, W0
wait_for_it51:   ; do the back proch then go half way along the line...
        CP  TMR1
        BRA LEU, wait_for_it51

    	bset	LATD, #1
        MOV #1300, W0
wait_for_it52:   ; do a bit of white...
        CP  TMR1
        BRA LEU, wait_for_it52
    	bclr	LATD, #1

        MOV #1886, W0
wait_for_it53:   ; do till the end of the line
        CP  TMR1
        BRA LEU, wait_for_it53

		return




;..............................................................................
;Subroutine: Initialization of W registers to 0x0000
;..............................................................................

_wreg_init:
        CLR W0
        MOV W0, W14
        REPEAT #12
        MOV W0, [++W14]
        CLR W14
        RETURN



;--------End of All Code Sections ---------------------------------------------

.end                               ;End of program code in this file

