lastintx% = 0
lastinty% = 0
lastloopx% = -32000
lastloopy% = -32000
errornum% = 7022
margin$ = "         "

' (c) Jon Prestidge 2006.  this program cenerates source code for us in the
' draw_small_vectors() C routine.
' Written to run under Microsoft Quick BASIC

CLS

OPEN "c:\$proj\antive~1\prefab.txt" FOR OUTPUT AS #1


regionheight% = 20

' (Amend the loopx%, loopy% loop limits from 8 to
'     your required maximum dx dy dimension)
FOR loopy% = 0 TO 8     
  FOR loopx% = 0 TO 8

    ' Draw the top of the box...
    LOCATE regionheight% - loopy% - 2, 5
    PRINT STRING$(loopx% + 1, "-");

    ' Draw the bottom of the box...
    LOCATE regionheight%, 5
    PRINT STRING$(loopx% + 1, "-");

    'Draw the left of the box...
    FOR i% = 0 TO loopy%
      LOCATE regionheight% - i% - 1, 4
      PRINT "|";
    NEXT i%

    'Draw the right of the box...
    FOR i% = 0 TO loopy%
      LOCATE regionheight% - i% - 1, 6 + loopx%
      PRINT "|";
    NEXT i%


    dx = loopx%      ' convert to floating point.
    dy = loopy%


    IF loopx% >= loopy% THEN
      section% = 1

      IF dx >= .0001 THEN
         grad = dy / dx
      ELSE ' prevent divide by zero...
         grad = 99999 ' make it a very big number -- OK for our purposes.
      END IF

      FOR i% = 0 TO loopx%

        x = i%
        y = x * grad

        GOSUB plotandwrite

      NEXT i%

    ELSE

      section% = 2

      IF dy >= .0001 THEN
         grad = dx / dy
      ELSE ' prevent divide by zero...
         grad = 99999 ' make it a very big number -- OK for our purposes.
      END IF

      FOR i% = 0 TO loopy%

        y = i%
        x = y * grad

        GOSUB plotandwrite

      NEXT i%

    END IF

    LOCATE regionheight% - 3, 1
    PRINT STR$(loopy%); "Y";
   
    LOCATE regionheight% + 1, 7
    PRINT STR$(loopx%); "X"

    PRINT : PRINT "Section"; section%: PRINT : PRINT

    INPUT a$
    'SLEEP 1
    CLS

  NEXT loopx%

NEXT loopy%



PRINT #1, "DOT  break;"  ' finish-off last line.
PRINT #1, margin$; "         }"
PRINT #1, margin$; "      break;"
PRINT #1, margin$; "   #if DIAGS"
PRINT #1, margin$; "    default:  err("; errornum%; ");"
PRINT #1, margin$; "   #endif"
PRINT #1, margin$; "   }"

CLOSE #1

END



plotandwrite:
'------------
       
intx% = x
inty% = y

' Plot it on the screen...
LOCATE regionheight% - (inty% + 1), intx% + 5
PRINT CHR$(i% + 48);


' Write-out stuff to the output file...

IF loopy% <> lastloopy% THEN

   IF loopy% > 0 THEN
      PRINT #1, "DOT  break;"
      PRINT #1, margin$; "         #if DIAGS"
      PRINT #1, margin$; "          default:  err("; errornum%; ");"
      errornum% = errornum% + 1
      PRINT #1, margin$; "         #endif"
      PRINT #1, margin$; "         }"
      PRINT #1, margin$; "      break;"
      PRINT #1, margin$; "      "
   ELSE
      PRINT #1, margin$; "switch( dy )"
      PRINT #1, margin$; "   {"
   END IF
   PRINT #1, margin$; "   case"; RTRIM$(STR$(loopy%)); ":    // "; loopy%; "pixel high vector."
   PRINT #1, margin$; "      switch( dx )"
   PRINT #1, margin$; "         {  // Now select on width of vector..."
END IF


IF loopx% <> lastloopx% THEN
   IF loopx% > 0 THEN PRINT #1, "DOT  break;"  ' finish-off last line.
   PRINT #1, margin$; "         case"; RTRIM$(STR$(loopx%)); ":  ";
END IF


xdiff% = intx% - lastintx%
ydiff% = inty% - lastinty%

IF xdiff% > 0 AND ydiff% = 0 THEN
   PRINT #1, "HOR ";
ELSEIF xdiff% > 0 AND ydiff% > 0 THEN
   PRINT #1, "DIA ";
ELSEIF xdiff% = 0 AND ydiff% > 0 THEN
   PRINT #1, "VER ";
END IF





lastintx% = intx%
lastinty% = inty%
lastloopx% = loopx%
lastloopy% = loopy%
RETURN

